//
//  MCSyncEvent.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 28/10/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <MCServerSupport/MCTrackedEvent.h>


enum {
	kMCEventTypeClientInit      = kMCEventTypeClientError + 1,
	kMCEventTypeClientSyncUp,
	kMCEventTypeClientSyncDown,
	kMCEventTypeClientReset,
	kMCEventTypeClientWipe	
};

extern NSString *kMCETSyncEventsIncludesFields;
extern NSString *kMCETSyncEventsIncludesValues;


@class MCChangeRecord;

@interface MCSyncEvent : MCTrackedEvent {

}

+ (BOOL)savesFields; // default is YES; if NO, won't save the changed attributes from change records; if NO, savesFieldValues is ignored
+ (void)setSavesFields:(BOOL)flag;
 
+ (BOOL)savesFieldValues; // default is YES; if NO, won't save the attribute values from change records
+ (void)setSavesFieldValues:(BOOL)flag;

- (void)addChange:(MCChangeRecord *)record;
- (void)addChanges:(NSArray *)records;
@end
